-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema covid
--

-- CREATE DATABASE IF NOT EXISTS covid;
-- USE covid;

--
-- Temporary table structure for view `v_continent`
--
DROP TABLE IF EXISTS `v_continent`;
DROP VIEW IF EXISTS `v_continent`;
CREATE TABLE `v_continent` (
  `continent` varchar(50)
);

--
-- Temporary table structure for view `v_country`
--
DROP TABLE IF EXISTS `v_country`;
DROP VIEW IF EXISTS `v_country`;
CREATE TABLE `v_country` (
  `continent` varchar(50),
  `country` varchar(50)
);

--
-- Temporary table structure for view `v_year_week`
--
DROP TABLE IF EXISTS `v_year_week`;
DROP VIEW IF EXISTS `v_year_week`;
CREATE TABLE `v_year_week` (
  `year_week` varchar(8)
);

--
-- Definition of table `covid_control`
--

DROP TABLE IF EXISTS `covid_control`;
CREATE TABLE `covid_control` (
  `id` int(11) NOT NULL,
  `update_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `covid_control`
--

/*!40000 ALTER TABLE `covid_control` DISABLE KEYS */;
INSERT INTO `covid_control` (`id`,`update_date`) VALUES 
 (1,'2022-01-19');
/*!40000 ALTER TABLE `covid_control` ENABLE KEYS */;


--
-- Definition of table `covid_country`
--

DROP TABLE IF EXISTS `covid_country`;
CREATE TABLE `covid_country` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `country` varchar(50) NOT NULL,
  `country_code` varchar(3) NOT NULL,
  `continent` varchar(50) NOT NULL,
  `population` double NOT NULL,
  `indicator` varchar(10) NOT NULL,
  `weekly_count` int(11) unsigned zerofill NOT NULL,
  `year_week` varchar(8) NOT NULL,
  `cumulative_count` int(11) unsigned zerofill DEFAULT NULL,
  `rate_14_day` double unsigned zerofill NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx1_covid_country` (`continent`),
  KEY `idx2_covid_country` (`country`),
  KEY `idx3_covid_country` (`year_week`),
  KEY `idx4_covid_country` (`country`,`year_week`,`indicator`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `covid_country`
--

/*!40000 ALTER TABLE `covid_country` DISABLE KEYS */;
/*!40000 ALTER TABLE `covid_country` ENABLE KEYS */;


--
-- Definition of table `covid_subcountry_cases`
--

DROP TABLE IF EXISTS `covid_subcountry_cases`;
CREATE TABLE `covid_subcountry_cases` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `country` varchar(50) NOT NULL,
  `region_name` varchar(80) NOT NULL,
  `nuts_code` varchar(20) NOT NULL,
  `year_week` varchar(8) NOT NULL,
  `rate_14_day_per_100k` double unsigned zerofill DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx1_covid_subcountry_cases` (`country`),
  KEY `idx3_covid_subcountry_cases` (`year_week`) USING BTREE,
  KEY `idx2_covid_subcountry_cases` (`region_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `covid_subcountry_cases`
--

/*!40000 ALTER TABLE `covid_subcountry_cases` DISABLE KEYS */;
/*!40000 ALTER TABLE `covid_subcountry_cases` ENABLE KEYS */;


--
-- Definition of table `covid_year_week`
--

DROP TABLE IF EXISTS `covid_year_week`;
CREATE TABLE `covid_year_week` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year_week` varchar(8) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `year_week_UNIQUE` (`year_week`)
) ENGINE=MyISAM AUTO_INCREMENT=146 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `covid_year_week`
--

/*!40000 ALTER TABLE `covid_year_week` DISABLE KEYS */;
INSERT INTO `covid_year_week` (`id`,`year_week`) VALUES 
 (1,'2020-13'),
 (2,'2020-14'),
 (3,'2020-15'),
 (4,'2020-16'),
 (5,'2020-17'),
 (6,'2020-18'),
 (7,'2020-19'),
 (8,'2020-20'),
 (9,'2020-21'),
 (10,'2020-22'),
 (11,'2020-23'),
 (12,'2020-24'),
 (13,'2020-25'),
 (14,'2020-26'),
 (15,'2020-27'),
 (16,'2020-28'),
 (17,'2020-29'),
 (18,'2020-30'),
 (19,'2020-31'),
 (20,'2020-32'),
 (21,'2020-33'),
 (22,'2020-34'),
 (23,'2020-35'),
 (24,'2020-36'),
 (25,'2020-37'),
 (26,'2020-38'),
 (27,'2020-39'),
 (28,'2020-40'),
 (29,'2020-41'),
 (30,'2020-42'),
 (31,'2020-43'),
 (32,'2020-44'),
 (33,'2020-45'),
 (34,'2020-46'),
 (35,'2020-47'),
 (36,'2020-48'),
 (37,'2020-49'),
 (38,'2020-50'),
 (39,'2020-51'),
 (40,'2020-52'),
 (41,'2020-53'),
 (42,'2021-01'),
 (43,'2021-02'),
 (44,'2021-03'),
 (45,'2021-04'),
 (46,'2021-05'),
 (47,'2021-06'),
 (48,'2021-07'),
 (49,'2021-08'),
 (50,'2021-09'),
 (51,'2021-10'),
 (52,'2021-11'),
 (53,'2021-12'),
 (54,'2021-13'),
 (55,'2021-14'),
 (56,'2021-15'),
 (57,'2021-16'),
 (58,'2021-17'),
 (59,'2021-18'),
 (60,'2021-19'),
 (61,'2021-20'),
 (62,'2021-21'),
 (63,'2021-22'),
 (64,'2021-23'),
 (65,'2021-24'),
 (66,'2021-25'),
 (67,'2021-26'),
 (68,'2021-27'),
 (69,'2021-28'),
 (70,'2021-29'),
 (71,'2021-30'),
 (72,'2021-31'),
 (73,'2021-32'),
 (74,'2021-33'),
 (75,'2021-34'),
 (76,'2021-35'),
 (77,'2021-36'),
 (78,'2021-37'),
 (79,'2021-38'),
 (80,'2021-39'),
 (81,'2021-40'),
 (82,'2021-41'),
 (83,'2021-42'),
 (84,'2021-43'),
 (85,'2021-44'),
 (86,'2021-45'),
 (87,'2021-46'),
 (88,'2021-47'),
 (89,'2021-48'),
 (90,'2021-49'),
 (91,'2021-50'),
 (92,'2021-51'),
 (93,'2021-52'),
 (94,'2022-01'),
 (95,'2022-02'),
 (96,'2022-03'),
 (97,'2022-04'),
 (98,'2022-05'),
 (99,'2022-06'),
 (100,'2022-07'),
 (101,'2022-08'),
 (102,'2022-09'),
 (103,'2022-10'),
 (104,'2022-11'),
 (105,'2022-12'),
 (106,'2022-13'),
 (107,'2022-14'),
 (108,'2022-15'),
 (109,'2022-16'),
 (110,'2022-17'),
 (111,'2022-18'),
 (112,'2022-19'),
 (113,'2022-20'),
 (114,'2022-21'),
 (115,'2022-22'),
 (116,'2022-23'),
 (117,'2022-24'),
 (118,'2022-25'),
 (119,'2022-26'),
 (120,'2022-27'),
 (121,'2022-28'),
 (122,'2022-29'),
 (123,'2022-30'),
 (124,'2022-31'),
 (125,'2022-32'),
 (126,'2022-33'),
 (127,'2022-34'),
 (128,'2022-35'),
 (129,'2022-36'),
 (130,'2022-37'),
 (131,'2022-38'),
 (132,'2022-39'),
 (133,'2022-40'),
 (134,'2022-41'),
 (135,'2022-42'),
 (136,'2022-43'),
 (137,'2022-44'),
 (138,'2022-45'),
 (139,'2022-46'),
 (140,'2022-47'),
 (141,'2022-48'),
 (142,'2022-49'),
 (143,'2022-50'),
 (144,'2022-51'),
 (145,'2022-52');
/*!40000 ALTER TABLE `covid_year_week` ENABLE KEYS */;


--
-- Definition of view `v_continent`
--

DROP TABLE IF EXISTS `v_continent`;
DROP VIEW IF EXISTS `v_continent`;
CREATE  VIEW `v_continent` AS select distinct `covid_country`.`continent` AS `continent` from `covid_country`;

--
-- Definition of view `v_country`
--

DROP TABLE IF EXISTS `v_country`;
DROP VIEW IF EXISTS `v_country`;
CREATE  VIEW `v_country` AS select distinct `covid_country`.`continent` AS `continent`,`covid_country`.`country` AS `country` from `covid_country`;

--
-- Definition of view `v_year_week`
--

DROP TABLE IF EXISTS `v_year_week`;
DROP VIEW IF EXISTS `v_year_week`;
CREATE  VIEW `v_year_week` AS select distinct `covid_subcountry_cases`.`year_week` AS `year_week` from `covid_subcountry_cases`;



/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
